$(document).ready(async function () {
  const initTabelas = () => {
    criaDataTablePadrao('#tabelaValoresMetas', false, false, false, false, true, false, false, null, null, []);
    criaDataTablePadrao('#tabelaOpcoesMetas', false, false, false, false, true, false, false, null, null, [], [5, 6]);
    criaDataTablePadrao('#tabelaMetas', false, false, false, false, true, false, false, null, null, [], [4, 5]);

    if ($('#tabelaMetas').DataTable().rows().count() < 6) {
      $('#tabelaMetas').css('min-height', '80px');
    }
  };

  const initFiltros = () => {
    ['empresa', 'vendedor', 'produto', 'material', 'colecao', 'grupo', 'cliente'].forEach(c => componenteFiltro(c, true, true));
  };

  const initMascaras = () => {
    $("#txtValorMeta, #txtPercentual").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
  };

  $('#txtPercentual').on('blur', function () {
    if (+$(this).val() > 100) {
      $(this).val("0.00");
    }
  });

  $('#check_todos').on('change', function () {
    const isChecked = $(this).prop('checked');
    $('.campoSel').prop('checked', isChecked).toggleClass('selecionado', isChecked);
  });



  $('#btnGravarMeta').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const idMeta = $('#txtIdMeta').val();
      const Meta = new Metas($('#txtSelectTipos').val(), $('#txtDescricaoMeta').val(), `${$('#txtDtInicial').val()}T00:00:00Z`, `${$('#txtDtFinal').val()}T00:00:00Z`, idMeta);

      if (Meta.validar()) Meta.gravar();

      if (idMeta) {
        criaMensagemSucesso(`Meta ${idMeta ? 'editada' : 'gravada'} com sucesso!`, () => {
          window.location.href = `${BASE_URI}/metas`;
        });
        return
      }

    } catch (e) {
      console.error(e);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/metas`;
  })

  const registrarGravacaoMeta = (campo) => {
    $('#btnGravarOpcoesMeta').on('click', async function () {
      try {
        $.LoadingOverlay('show');

        const idMeta = $('#txtIdMeta').val();
        const idValor = $('#txtIdValorMetaSelecionado').val();
        if (!parseInt(idMeta)) {
          msgAlerta('Meta não gravada ainda, deseja gravar a meta antes?', () => {
            const idMeta = $('#txtIdMeta').val();
            const Meta = new Metas($('#txtSelectTipos').val(), $('#txtDescricaoMeta').val(), `${$('#txtDtInicial').val()}T00:00:00Z`, `${$('#txtDtFinal').val()}T00:00:00Z`, idMeta);
      
            if (Meta.validar()) Meta.gravar();

          });
          return;
        }
        const tipo = $('#txtSelectTipos').val().toLowerCase();

        if (tipo == campo.toLowerCase()) {
          const id = campo === 'Loja' ? 'Empresa' : campo;

          const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $(`#txt${id}`).val(), idMeta, idValor);
          if (metasOpcoes.idValor) {
            if (metasOpcoes.validar()) await metasOpcoes.editar();
            return;
          }

          if (metasOpcoes.validar()) await metasOpcoes.gravarOpcoes();
        }

      } catch (e) {
        console.error(e);
      } finally {
        $.LoadingOverlay('hide');
      }
    });
  };

  ['Loja', 'Vendedor', 'Produto', 'Material', 'Colecao', 'Grupo', 'Cliente'].forEach(registrarGravacaoMeta);

  $('#txtDtInicial, #txtDtFinal').on('blur', function () {
    const dataInicial = $('#txtDtInicial').val();
    const dataFinal = $('#txtDtFinal').val();
    if (!dataInicial || !dataFinal) return;

    const meta = new Metas($('#txtSelectTipos').val(), $('#txtDescricaoMeta').val(), $('#txtDtInicial').val(), $('#txtDtFinal').val(), $('#txtIdMeta').val());
    meta.carregaDias();
  });

  $('#cbTodos').on('change', async function () {
    if (!$(this).is(':checked')) {
      $('#txtVendedor').empty().trigger('change');
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['CODREP', 'NOME'],
      where: []
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    await insereValorPesquisaVarios('txtVendedor', 'CODREP', 'NOME', jsonStr);
    $('#txtVendedor').trigger('change');
    $('.txtVendedor').trigger('click');
  });

  $('#btnExplodir').on('click', () => $('#modalDiasMeta').modal('show'));
  $('#btnVincularDias').on('click', () => $('#modalVincularDiasMeta').modal('show'));
  $('#btnConfirmarDias').on('click', () => $('#modalDiasMeta').modal('hide'));

  $('#modalVincularDiasMeta, #modalDiasMeta, #modalDiasValor').on('shown.bs.modal', function () {
    $(this).find("table").DataTable().columns.adjust().draw(false);
  });

  $('#btnExplodir').on('click', () => {
    $("#tabelaDiasMeta").DataTable().rows().data().each((item, index) => {
      $($('.campoSel')[index]).prop('checked', item.DIA_UTIL === 'S');
    });
  });

  $('#btnSelecionarEmpresas').on('click', async () => await carregaEmpresasDisponiveis());

  $('#txtSelectTipos').on('change', function () {
    const tipo = $(this).val();
    const campos = ['#txtOperacaoMeta', '#txtValorMeta', '#txtPercentual', '#btnSelecionarEmpresas', '#btnGravarOpcoes', '#btnExplodir'];

    campos.forEach(id => $(id).prop('disabled', tipo === ''));
  });

  initTabelas();
  initFiltros();
  initMascaras();

  await new Metas().carregaValoresMeta();
});
